/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class Finalizer<T> {
    public static final FinalizerMonitor IGNORE_FINALIZER_MONITOR = new FinalizerMonitor(){

        @Override
        public void unexpectedException(Throwable throwable) {
        }
    };
    private final int threads;
    private final FinalizerMonitor monitor;
    private final ConcurrentHashMap<FinalizerPhantomReference<T>, Object> references = new ConcurrentHashMap();
    private final ReferenceQueue<T> referenceQueue = new ReferenceQueue();
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private ExecutorService executor;

    public Finalizer() {
        this(1, IGNORE_FINALIZER_MONITOR);
    }

    public Finalizer(int threads) {
        this(1, IGNORE_FINALIZER_MONITOR);
    }

    public Finalizer(int threads, FinalizerMonitor monitor) {
        this.monitor = monitor;
        Preconditions.checkArgument(threads >= 1, "threads must be at least 1");
        this.threads = threads;
    }

    public synchronized void addCleanup(T item, Callable<?> cleanup) {
        Preconditions.checkNotNull(item, "item is null");
        Preconditions.checkNotNull(cleanup, "cleanup is null");
        Preconditions.checkState(!this.destroyed.get(), "%s is destroyed", this.getClass().getName());
        if (this.executor == null) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("FinalizerQueueProcessor-%d").setDaemon(true).build();
            this.executor = Executors.newFixedThreadPool(this.threads, threadFactory);
            for (int i = 0; i < this.threads; ++i) {
                this.executor.submit(new FinalizerQueueProcessor());
            }
        }
        FinalizerPhantomReference reference = new FinalizerPhantomReference(item, this.referenceQueue, cleanup);
        this.references.put(reference, Boolean.TRUE);
    }

    public synchronized void destroy() {
        this.destroyed.set(true);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        for (FinalizerPhantomReference r : this.references.keySet()) {
            try {
                r.cleanup();
            }
            catch (Exception exception) {}
        }
    }

    private class FinalizerQueueProcessor
    implements Runnable {
        private FinalizerQueueProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Finalizer.this.destroyed.get()) {
                boolean rescheduleAndReturn;
                block12: {
                    FinalizerPhantomReference reference;
                    try {
                        reference = (FinalizerPhantomReference)Finalizer.this.referenceQueue.remove();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    Finalizer.this.references.remove(reference);
                    rescheduleAndReturn = false;
                    try {
                        reference.cleanup();
                        rescheduleAndReturn = Thread.currentThread().isInterrupted();
                    }
                    catch (Throwable userException) {
                        try {
                            Finalizer.this.monitor.unexpectedException(userException);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (userException instanceof InterruptedException) {
                            rescheduleAndReturn = true;
                            Thread.currentThread().interrupt();
                        }
                        if (!(userException instanceof Error)) break block12;
                        rescheduleAndReturn = true;
                    }
                }
                if (!rescheduleAndReturn) continue;
                Finalizer finalizer = Finalizer.this;
                synchronized (finalizer) {
                    if (!Finalizer.this.destroyed.get()) {
                        Finalizer.this.executor.submit(new FinalizerQueueProcessor());
                    }
                }
                return;
            }
        }
    }

    private static class FinalizerPhantomReference<T>
    extends PhantomReference<T> {
        private final AtomicBoolean cleaned = new AtomicBoolean(false);
        private final Callable<?> cleanup;

        private FinalizerPhantomReference(T referent, ReferenceQueue<? super T> queue, Callable<?> cleanup) {
            super(referent, queue);
            this.cleanup = cleanup;
        }

        private void cleanup() throws Exception {
            if (this.cleaned.compareAndSet(false, true)) {
                this.cleanup.call();
            }
        }
    }

    public static interface FinalizerMonitor {
        public void unexpectedException(Throwable var1);
    }
}

