/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.Slice;

public class InternalUserComparator
implements UserComparator {
    private final InternalKeyComparator internalKeyComparator;

    public InternalUserComparator(InternalKeyComparator internalKeyComparator) {
        this.internalKeyComparator = internalKeyComparator;
    }

    @Override
    public int compare(Slice left, Slice right) {
        return this.internalKeyComparator.compare(new InternalKey(left), new InternalKey(right));
    }

    @Override
    public String name() {
        return this.internalKeyComparator.name();
    }

    @Override
    public Slice findShortestSeparator(Slice start, Slice limit) {
        Slice startUserKey = new InternalKey(start).getUserKey();
        Slice limitUserKey = new InternalKey(limit).getUserKey();
        Slice shortestSeparator = this.internalKeyComparator.getUserComparator().findShortestSeparator(startUserKey, limitUserKey);
        if (this.internalKeyComparator.getUserComparator().compare(startUserKey, shortestSeparator) < 0) {
            InternalKey newInternalKey = new InternalKey(shortestSeparator, 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
            Preconditions.checkState(this.compare(start, newInternalKey.encode()) < 0);
            Preconditions.checkState(this.compare(newInternalKey.encode(), limit) < 0);
            return newInternalKey.encode();
        }
        return start;
    }

    @Override
    public Slice findShortSuccessor(Slice key) {
        Slice userKey = new InternalKey(key).getUserKey();
        Slice shortSuccessor = this.internalKeyComparator.getUserComparator().findShortSuccessor(userKey);
        if (this.internalKeyComparator.getUserComparator().compare(userKey, shortSuccessor) < 0) {
            InternalKey newInternalKey = new InternalKey(shortSuccessor, 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
            Preconditions.checkState(this.compare(key, newInternalKey.encode()) < 0);
            return newInternalKey.encode();
        }
        return key;
    }
}

